/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.Config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.Whitedraco.switchbow.Initial;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class CraftingConfig {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static File ConfigPathCraftingRecipes = new File("config/SwitchBow/Crafting-Recipes");
    private static FileSystem filesystem;

    static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static void writeConfigCrafting() throws IOException, URISyntaxException {
        String[] fileNames = CraftingConfig.getResourceListing(Initial.class, "assets/switchbow/recipes_template/");
        for (int i = 0; i < fileNames.length; ++i) {
            if (!"json".equals(FilenameUtils.getExtension((String)fileNames[i]))) continue;
            String recipeName = fileNames[i];
            InputStream reader = Initial.class.getResourceAsStream("/assets/switchbow/recipes_template/" + recipeName);
            CraftingConfig.copy(reader, "config/SwitchBow/Crafting-Recipes/" + recipeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCraftingConfig() throws IOException {
        Iterator iterator = Files.walk(ConfigPathCraftingRecipes.toPath(), new FileVisitOption[0]).iterator();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        while (iterator.hasNext()) {
            Path path1 = (Path)iterator.next();
            if (!"json".equals(FilenameUtils.getExtension((String)path1.toString()))) continue;
            Path path2 = ConfigPathCraftingRecipes.toPath().relativize(path1);
            String s = FilenameUtils.removeExtension((String)path2.toString()).replaceAll("\\\\", "/");
            ResourceLocation resourcelocation = new ResourceLocation("switchbow".toLowerCase(), s);
            BufferedReader bufferedreader = null;
            try {
                try {
                    bufferedreader = Files.newBufferedReader(path1);
                    Object recipe = CraftingConfig.parseRecipeJson((JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)bufferedreader, JsonObject.class), s);
                    if (recipe == null) continue;
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)((IRecipe)recipe));
                }
                catch (JsonParseException jsonparseexception) {
                    System.out.println("Parsing error loading recipe " + resourcelocation);
                    System.out.println(jsonparseexception.getLocalizedMessage());
                    boolean flag = false;
                }
                catch (IOException ioexception) {
                    System.out.println("Couldn't read recipe " + resourcelocation + " from " + path1);
                    boolean bl = false;
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedreader);
            }
        }
    }

    private static Object parseRecipeJson(JsonObject fromJson, String s2) {
        String s = JsonUtils.func_151200_h((JsonObject)fromJson, (String)"type");
        String activ = JsonUtils.func_151200_h((JsonObject)fromJson, (String)"activ");
        boolean active = true;
        if (activ.equals("false")) {
            return null;
        }
        if (s.contains("crafting_shaped")) {
            ShapedRecipes recipe = ShapedRecipes.func_193362_a((JsonObject)fromJson);
            recipe.setRegistryName("switchbow".toLowerCase(), s2);
            return recipe;
        }
        if (s.contains("crafting_shapeless")) {
            ShapelessRecipes recipe = ShapelessRecipes.func_193363_a((JsonObject)fromJson);
            recipe.setRegistryName("switchbow".toLowerCase(), s2);
            return recipe;
        }
        throw new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'");
    }

    public static boolean copy(InputStream source, String destination) {
        boolean succeess = true;
        File tester = new File(destination);
        try {
            if (!tester.exists() && source != null) {
                System.out.println("Copying Recipe ->" + source + "\n\tto ->" + destination);
                Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            succeess = false;
        }
        return succeess;
    }

    public static File getPath() {
        return ConfigPathCraftingRecipes;
    }
}

